/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.18.1
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */
!function(t,e){"use strict";t.URI=function(t,e,r,s){var n=s&&s.URI;function a(t,e){var r=arguments.length>=1,s=arguments.length>=2;if(!(this instanceof a))return r?s?new a(t,e):new a(t):new a;if(void 0===t){if(r)throw new TypeError("undefined is not a valid argument for URI");t="undefined"!=typeof location?location.href+"":""}return this.href(t),void 0!==e?this.absoluteTo(e):this}a.version="1.18.1";var i=a.prototype,o=Object.prototype.hasOwnProperty;function h(t){return t.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function u(t){return void 0===t?"Undefined":String(Object.prototype.toString.call(t)).slice(8,-1)}function p(t){return"Array"===u(t)}function c(t,e){var r,s,n={};if("RegExp"===u(e))n=null;else if(p(e))for(r=0,s=e.length;r<s;r++)n[e[r]]=!0;else n[e]=!0;for(r=0,s=t.length;r<s;r++){(n&&void 0!==n[t[r]]||!n&&e.test(t[r]))&&(t.splice(r,1),s--,r--)}return t}function l(t,e){var r,s;if(p(e)){for(r=0,s=e.length;r<s;r++)if(!l(t,e[r]))return!1;return!0}var n=u(e);for(r=0,s=t.length;r<s;r++)if("RegExp"===n){if("string"==typeof t[r]&&t[r].match(e))return!0}else if(t[r]===e)return!0;return!1}function d(t,e){if(!p(t)||!p(e))return!1;if(t.length!==e.length)return!1;t.sort(),e.sort();for(var r=0,s=t.length;r<s;r++)if(t[r]!==e[r])return!1;return!0}function f(t){return t.replace(/^\/+|\/+$/g,"")}function m(t){return escape(t)}function g(t){return encodeURIComponent(t).replace(/[!'()*]/g,m).replace(/\*/g,"%2A")}a._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,duplicateQueryParameters:a.duplicateQueryParameters,escapeQuerySpace:a.escapeQuerySpace}},a.duplicateQueryParameters=!1,a.escapeQuerySpace=!0,a.protocol_expression=/^[a-z][a-z0-9.+-]*$/i,a.idn_expression=/[^a-z0-9\.-]/i,a.punycode_expression=/(xn--)/i,a.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,a.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,a.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/gi,a.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?«»“”„‘’]+$/},a.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"},a.invalid_hostname_characters=/[^a-zA-Z0-9\.-]/,a.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"},a.getDomAttribute=function(t){if(t&&t.nodeName){var e=t.nodeName.toLowerCase();if("input"!==e||"image"===t.type)return a.domAttributes[e]}},a.encode=g,a.decode=decodeURIComponent,a.iso8859=function(){a.encode=escape,a.decode=unescape},a.unicode=function(){a.encode=g,a.decode=decodeURIComponent},a.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/gi,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/gi,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/gi,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}},a.encodeQuery=function(t,e){var r=a.encode(t+"");return void 0===e&&(e=a.escapeQuerySpace),e?r.replace(/%20/g,"+"):r},a.decodeQuery=function(t,e){t+="",void 0===e&&(e=a.escapeQuerySpace);try{return a.decode(e?t.replace(/\+/g,"%20"):t)}catch(e){return t}};var _,y={encode:"encode",decode:"decode"},v=function(t,e){return function(r){try{return a[e](r+"").replace(a.characters[t][e].expression,(function(r){return a.characters[t][e].map[r]}))}catch(t){return r}}};for(_ in y)a[_+"PathSegment"]=v("pathname",y[_]),a[_+"UrnPathSegment"]=v("urnpath",y[_]);var b=function(t,e,r){return function(s){var n;n=r?function(t){return a[e](a[r](t))}:a[e];for(var i=(s+"").split(t),o=0,h=i.length;o<h;o++)i[o]=n(i[o]);return i.join(t)}};function w(t){return function(e,r){return void 0===e?this._parts[t]||"":(this._parts[t]=e||null,this.build(!r),this)}}function Q(t,e){return function(r,s){return void 0===r?this._parts[t]||"":(null!==r&&(r+="").charAt(0)===e&&(r=r.substring(1)),this._parts[t]=r,this.build(!s),this)}}a.decodePath=b("/","decodePathSegment"),a.decodeUrnPath=b(":","decodeUrnPathSegment"),a.recodePath=b("/","encodePathSegment","decode"),a.recodeUrnPath=b(":","encodeUrnPathSegment","decode"),a.encodeReserved=v("reserved","encode"),a.parse=function(t,e){var r;return e||(e={}),(r=t.indexOf("#"))>-1&&(e.fragment=t.substring(r+1)||null,t=t.substring(0,r)),(r=t.indexOf("?"))>-1&&(e.query=t.substring(r+1)||null,t=t.substring(0,r)),"//"===t.substring(0,2)?(e.protocol=null,t=t.substring(2),t=a.parseAuthority(t,e)):(r=t.indexOf(":"))>-1&&(e.protocol=t.substring(0,r)||null,e.protocol&&!e.protocol.match(a.protocol_expression)?e.protocol=void 0:"//"===t.substring(r+1,r+3)?(t=t.substring(r+3),t=a.parseAuthority(t,e)):(t=t.substring(r+1),e.urn=!0)),e.path=t,e},a.parseHost=function(t,e){var r,s,n=(t=t.replace(/\\/g,"/")).indexOf("/");if(-1===n&&(n=t.length),"["===t.charAt(0))r=t.indexOf("]"),e.hostname=t.substring(1,r)||null,e.port=t.substring(r+2,n)||null,"/"===e.port&&(e.port=null);else{var a=t.indexOf(":"),i=t.indexOf("/"),o=t.indexOf(":",a+1);-1!==o&&(-1===i||o<i)?(e.hostname=t.substring(0,n)||null,e.port=null):(s=t.substring(0,n).split(":"),e.hostname=s[0]||null,e.port=s[1]||null)}return e.hostname&&"/"!==t.substring(n).charAt(0)&&(n++,t="/"+t),t.substring(n)||"/"},a.parseAuthority=function(t,e){return t=a.parseUserinfo(t,e),a.parseHost(t,e)},a.parseUserinfo=function(t,e){var r,s=t.indexOf("/"),n=t.lastIndexOf("@",s>-1?s:t.length-1);return n>-1&&(-1===s||n<s)?(r=t.substring(0,n).split(":"),e.username=r[0]?a.decode(r[0]):null,r.shift(),e.password=r[0]?a.decode(r.join(":")):null,t=t.substring(n+1)):(e.username=null,e.password=null),t},a.parseQuery=function(t,e){if(!t)return{};if(!(t=t.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"")))return{};for(var r,s,n,i={},h=t.split("&"),u=h.length,p=0;p<u;p++)r=h[p].split("="),s=a.decodeQuery(r.shift(),e),n=r.length?a.decodeQuery(r.join("="),e):null,o.call(i,s)?("string"!=typeof i[s]&&null!==i[s]||(i[s]=[i[s]]),i[s].push(n)):i[s]=n;return i},a.build=function(t){var e="";return t.protocol&&(e+=t.protocol+":"),t.urn||!e&&!t.hostname||(e+="//"),e+=a.buildAuthority(t)||"","string"==typeof t.path&&("/"!==t.path.charAt(0)&&"string"==typeof t.hostname&&(e+="/"),e+=t.path),"string"==typeof t.query&&t.query&&(e+="?"+t.query),"string"==typeof t.fragment&&t.fragment&&(e+="#"+t.fragment),e},a.buildHost=function(t){var e="";return t.hostname?(a.ip6_expression.test(t.hostname)?e+="["+t.hostname+"]":e+=t.hostname,t.port&&(e+=":"+t.port),e):""},a.buildAuthority=function(t){return a.buildUserinfo(t)+a.buildHost(t)},a.buildUserinfo=function(t){var e="";return t.username&&(e+=a.encode(t.username)),t.password&&(e+=":"+a.encode(t.password)),e&&(e+="@"),e},a.buildQuery=function(t,e,r){var s,n,i,h,u="";for(n in t)if(o.call(t,n)&&n)if(p(t[n]))for(s={},i=0,h=t[n].length;i<h;i++)void 0!==t[n][i]&&void 0===s[t[n][i]+""]&&(u+="&"+a.buildQueryParameter(n,t[n][i],r),!0!==e&&(s[t[n][i]+""]=!0));else void 0!==t[n]&&(u+="&"+a.buildQueryParameter(n,t[n],r));return u.substring(1)},a.buildQueryParameter=function(t,e,r){return a.encodeQuery(t,r)+(null!==e?"="+a.encodeQuery(e,r):"")},a.addQuery=function(t,e,r){if("object"==typeof e)for(var s in e)o.call(e,s)&&a.addQuery(t,s,e[s]);else{if("string"!=typeof e)throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");if(void 0===t[e])return void(t[e]=r);"string"==typeof t[e]&&(t[e]=[t[e]]),p(r)||(r=[r]),t[e]=(t[e]||[]).concat(r)}},a.removeQuery=function(t,e,r){var s,n,i;if(p(e))for(s=0,n=e.length;s<n;s++)t[e[s]]=void 0;else if("RegExp"===u(e))for(i in t)e.test(i)&&(t[i]=void 0);else if("object"==typeof e)for(i in e)o.call(e,i)&&a.removeQuery(t,i,e[i]);else{if("string"!=typeof e)throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");void 0!==r?"RegExp"===u(r)?!p(t[e])&&r.test(t[e])?t[e]=void 0:t[e]=c(t[e],r):t[e]!==String(r)||p(r)&&1!==r.length?p(t[e])&&(t[e]=c(t[e],r)):t[e]=void 0:t[e]=void 0}},a.hasQuery=function(t,e,r,s){switch(u(e)){case"String":break;case"RegExp":for(var n in t)if(o.call(t,n)&&e.test(n)&&(void 0===r||a.hasQuery(t,n,r)))return!0;return!1;case"Object":for(var i in e)if(o.call(e,i)&&!a.hasQuery(t,i,e[i]))return!1;return!0;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter")}switch(u(r)){case"Undefined":return e in t;case"Boolean":return r===Boolean(p(t[e])?t[e].length:t[e]);case"Function":return!!r(t[e],e,t);case"Array":return!!p(t[e])&&(s?l:d)(t[e],r);case"RegExp":return p(t[e])?!!s&&l(t[e],r):Boolean(t[e]&&t[e].match(r));case"Number":r=String(r);case"String":return p(t[e])?!!s&&l(t[e],r):t[e]===r;default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}},a.joinPaths=function(){for(var t=[],e=[],r=0,s=0;s<arguments.length;s++){var n=new a(arguments[s]);t.push(n);for(var i=n.segment(),o=0;o<i.length;o++)"string"==typeof i[o]&&e.push(i[o]),i[o]&&r++}if(!e.length||!r)return new a("");var h=new a("").segment(e);return""!==t[0].path()&&"/"!==t[0].path().slice(0,1)||h.path("/"+h.path()),h.normalize()},a.commonPath=function(t,e){var r,s=Math.min(t.length,e.length);for(r=0;r<s;r++)if(t.charAt(r)!==e.charAt(r)){r--;break}return r<1?t.charAt(0)===e.charAt(0)&&"/"===t.charAt(0)?"/":"":("/"===t.charAt(r)&&"/"===e.charAt(r)||(r=t.substring(0,r).lastIndexOf("/")),t.substring(0,r+1))},a.withinString=function(t,e,r){r||(r={});var s=r.start||a.findUri.start,n=r.end||a.findUri.end,i=r.trim||a.findUri.trim,o=/[a-z0-9-]=["']?$/i;for(s.lastIndex=0;;){var h=s.exec(t);if(!h)break;var u=h.index;if(r.ignoreHtml){var p=t.slice(Math.max(u-3,0),u);if(p&&o.test(p))continue}var c=u+t.slice(u).search(n),l=t.slice(u,c).replace(i,"");if(!r.ignore||!r.ignore.test(l)){var d=e(l,u,c=u+l.length,t);t=t.slice(0,u)+d+t.slice(c),s.lastIndex=u+d.length}}return s.lastIndex=0,t},a.ensureValidHostname=function(e){if(e.match(a.invalid_hostname_characters)){if(!t)throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-] and Punycode.js is not available');if(t.toASCII(e).match(a.invalid_hostname_characters))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}},a.noConflict=function(t){if(t){var e={URI:this.noConflict()};return s.URITemplate&&"function"==typeof s.URITemplate.noConflict&&(e.URITemplate=s.URITemplate.noConflict()),s.IPv6&&"function"==typeof s.IPv6.noConflict&&(e.IPv6=s.IPv6.noConflict()),s.SecondLevelDomains&&"function"==typeof s.SecondLevelDomains.noConflict&&(e.SecondLevelDomains=s.SecondLevelDomains.noConflict()),e}return s.URI===this&&(s.URI=n),this},i.build=function(t){return!0===t?this._deferred_build=!0:(void 0===t||this._deferred_build)&&(this._string=a.build(this._parts),this._deferred_build=!1),this},i.clone=function(){return new a(this)},i.valueOf=i.toString=function(){return this.build(!1)._string},i.protocol=w("protocol"),i.username=w("username"),i.password=w("password"),i.hostname=w("hostname"),i.port=w("port"),i.query=Q("query","?"),i.fragment=Q("fragment","#"),i.search=function(t,e){var r=this.query(t,e);return"string"==typeof r&&r.length?"?"+r:r},i.hash=function(t,e){var r=this.fragment(t,e);return"string"==typeof r&&r.length?"#"+r:r},i.pathname=function(t,e){if(void 0===t||!0===t){var r=this._parts.path||(this._parts.hostname?"/":"");return t?(this._parts.urn?a.decodeUrnPath:a.decodePath)(r):r}return this._parts.urn?this._parts.path=t?a.recodeUrnPath(t):"":this._parts.path=t?a.recodePath(t):"/",this.build(!e),this},i.path=i.pathname,i.href=function(t,e){var r;if(void 0===t)return this.toString();this._string="",this._parts=a._parts();var s=t instanceof a,n="object"==typeof t&&(t.hostname||t.path||t.pathname);t.nodeName&&(t=t[a.getDomAttribute(t)]||"",n=!1);if(!s&&n&&void 0!==t.pathname&&(t=t.toString()),"string"==typeof t||t instanceof String)this._parts=a.parse(String(t),this._parts);else{if(!s&&!n)throw new TypeError("invalid input");var i=s?t._parts:t;for(r in i)o.call(this._parts,r)&&(this._parts[r]=i[r])}return this.build(!e),this},i.is=function(t){var e=!1,s=!1,n=!1,i=!1,o=!1,h=!1,u=!1,p=!this._parts.urn;switch(this._parts.hostname&&(p=!1,s=a.ip4_expression.test(this._parts.hostname),n=a.ip6_expression.test(this._parts.hostname),o=(i=!(e=s||n))&&r&&r.has(this._parts.hostname),h=i&&a.idn_expression.test(this._parts.hostname),u=i&&a.punycode_expression.test(this._parts.hostname)),t.toLowerCase()){case"relative":return p;case"absolute":return!p;case"domain":case"name":return i;case"sld":return o;case"ip":return e;case"ip4":case"ipv4":case"inet4":return s;case"ip6":case"ipv6":case"inet6":return n;case"idn":return h;case"url":return!this._parts.urn;case"urn":return!!this._parts.urn;case"punycode":return u}return null};var A=i.protocol,P=i.port,x=i.hostname;i.protocol=function(t,e){if(void 0!==t&&t&&!(t=t.replace(/:(\/\/)?$/,"")).match(a.protocol_expression))throw new TypeError('Protocol "'+t+"\" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]");return A.call(this,t,e)},i.scheme=i.protocol,i.port=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0!==t&&(0===t&&(t=null),t&&(":"===(t+="").charAt(0)&&(t=t.substring(1)),t.match(/[^0-9]/))))throw new TypeError('Port "'+t+'" contains characters other than [0-9]');return P.call(this,t,e)},i.hostname=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0!==t){var r={};if("/"!==a.parseHost(t,r))throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-]');t=r.hostname}return x.call(this,t,e)},i.origin=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0===t){var r=this.protocol();return this.authority()?(r?r+"://":"")+this.authority():""}var s=a(t);return this.protocol(s.protocol()).authority(s.authority()).build(!e),this},i.host=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0===t)return this._parts.hostname?a.buildHost(this._parts):"";if("/"!==a.parseHost(t,this._parts))throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-]');return this.build(!e),this},i.authority=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0===t)return this._parts.hostname?a.buildAuthority(this._parts):"";if("/"!==a.parseAuthority(t,this._parts))throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-]');return this.build(!e),this},i.userinfo=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0===t){var r=a.buildUserinfo(this._parts);return r?r.substring(0,r.length-1):r}return"@"!==t[t.length-1]&&(t+="@"),a.parseUserinfo(t,this._parts),this.build(!e),this},i.resource=function(t,e){var r;return void 0===t?this.path()+this.search()+this.hash():(r=a.parse(t),this._parts.path=r.path,this._parts.query=r.query,this._parts.fragment=r.fragment,this.build(!e),this)},i.subdomain=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0===t){if(!this._parts.hostname||this.is("IP"))return"";var r=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,r)||""}var s=this._parts.hostname.length-this.domain().length,n=this._parts.hostname.substring(0,s),i=new RegExp("^"+h(n));return t&&"."!==t.charAt(t.length-1)&&(t+="."),t&&a.ensureValidHostname(t),this._parts.hostname=this._parts.hostname.replace(i,t),this.build(!e),this},i.domain=function(t,e){if(this._parts.urn)return void 0===t?"":this;if("boolean"==typeof t&&(e=t,t=void 0),void 0===t){if(!this._parts.hostname||this.is("IP"))return"";var r=this._parts.hostname.match(/\./g);if(r&&r.length<2)return this._parts.hostname;var s=this._parts.hostname.length-this.tld(e).length-1;return s=this._parts.hostname.lastIndexOf(".",s-1)+1,this._parts.hostname.substring(s)||""}if(!t)throw new TypeError("cannot set domain empty");if(a.ensureValidHostname(t),!this._parts.hostname||this.is("IP"))this._parts.hostname=t;else{var n=new RegExp(h(this.domain())+"$");this._parts.hostname=this._parts.hostname.replace(n,t)}return this.build(!e),this},i.tld=function(t,e){if(this._parts.urn)return void 0===t?"":this;if("boolean"==typeof t&&(e=t,t=void 0),void 0===t){if(!this._parts.hostname||this.is("IP"))return"";var s=this._parts.hostname.lastIndexOf("."),n=this._parts.hostname.substring(s+1);return!0!==e&&r&&r.list[n.toLowerCase()]&&r.get(this._parts.hostname)||n}var a;if(!t)throw new TypeError("cannot set TLD empty");if(t.match(/[^a-zA-Z0-9-]/)){if(!r||!r.is(t))throw new TypeError('TLD "'+t+'" contains characters other than [A-Z0-9]');a=new RegExp(h(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(a,t)}else{if(!this._parts.hostname||this.is("IP"))throw new ReferenceError("cannot set TLD on non-domain host");a=new RegExp(h(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(a,t)}return this.build(!e),this},i.directory=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0===t||!0===t){if(!this._parts.path&&!this._parts.hostname)return"";if("/"===this._parts.path)return"/";var r=this._parts.path.length-this.filename().length-1,s=this._parts.path.substring(0,r)||(this._parts.hostname?"/":"");return t?a.decodePath(s):s}var n=this._parts.path.length-this.filename().length,i=this._parts.path.substring(0,n),o=new RegExp("^"+h(i));return this.is("relative")||(t||(t="/"),"/"!==t.charAt(0)&&(t="/"+t)),t&&"/"!==t.charAt(t.length-1)&&(t+="/"),t=a.recodePath(t),this._parts.path=this._parts.path.replace(o,t),this.build(!e),this},i.filename=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0===t||!0===t){if(!this._parts.path||"/"===this._parts.path)return"";var r=this._parts.path.lastIndexOf("/"),s=this._parts.path.substring(r+1);return t?a.decodePathSegment(s):s}var n=!1;"/"===t.charAt(0)&&(t=t.substring(1)),t.match(/\.?\//)&&(n=!0);var i=new RegExp(h(this.filename())+"$");return t=a.recodePath(t),this._parts.path=this._parts.path.replace(i,t),n?this.normalizePath(e):this.build(!e),this},i.suffix=function(t,e){if(this._parts.urn)return void 0===t?"":this;if(void 0===t||!0===t){if(!this._parts.path||"/"===this._parts.path)return"";var r,s,n=this.filename(),i=n.lastIndexOf(".");return-1===i?"":(r=n.substring(i+1),s=/^[a-z0-9%]+$/i.test(r)?r:"",t?a.decodePathSegment(s):s)}"."===t.charAt(0)&&(t=t.substring(1));var o,u=this.suffix();if(u)o=t?new RegExp(h(u)+"$"):new RegExp(h("."+u)+"$");else{if(!t)return this;this._parts.path+="."+a.recodePath(t)}return o&&(t=a.recodePath(t),this._parts.path=this._parts.path.replace(o,t)),this.build(!e),this},i.segment=function(t,e,r){var s=this._parts.urn?":":"/",n=this.path(),a="/"===n.substring(0,1),i=n.split(s);if(void 0!==t&&"number"!=typeof t&&(r=e,e=t,t=void 0),void 0!==t&&"number"!=typeof t)throw new Error('Bad segment "'+t+'", must be 0-based integer');if(a&&i.shift(),t<0&&(t=Math.max(i.length+t,0)),void 0===e)return void 0===t?i:i[t];if(null===t||void 0===i[t])if(p(e)){i=[];for(var o=0,h=e.length;o<h;o++)(e[o].length||i.length&&i[i.length-1].length)&&(i.length&&!i[i.length-1].length&&i.pop(),i.push(f(e[o])))}else(e||"string"==typeof e)&&(e=f(e),""===i[i.length-1]?i[i.length-1]=e:i.push(e));else e?i[t]=f(e):i.splice(t,1);return a&&i.unshift(""),this.path(i.join(s),r)},i.segmentCoded=function(t,e,r){var s,n,i;if("number"!=typeof t&&(r=e,e=t,t=void 0),void 0===e){if(p(s=this.segment(t,e,r)))for(n=0,i=s.length;n<i;n++)s[n]=a.decode(s[n]);else s=void 0!==s?a.decode(s):void 0;return s}if(p(e))for(n=0,i=e.length;n<i;n++)e[n]=a.encode(e[n]);else e="string"==typeof e||e instanceof String?a.encode(e):e;return this.segment(t,e,r)};var S=i.query;return i.query=function(t,e){if(!0===t)return a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("function"==typeof t){var r=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace),s=t.call(this,r);return this._parts.query=a.buildQuery(s||r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!e),this}return void 0!==t&&"string"!=typeof t?(this._parts.query=a.buildQuery(t,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!e),this):S.call(this,t,e)},i.setQuery=function(t,e,r){var s=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("string"==typeof t||t instanceof String)s[t]=void 0!==e?e:null;else{if("object"!=typeof t)throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");for(var n in t)o.call(t,n)&&(s[n]=t[n])}return this._parts.query=a.buildQuery(s,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),"string"!=typeof t&&(r=e),this.build(!r),this},i.addQuery=function(t,e,r){var s=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return a.addQuery(s,t,void 0===e?null:e),this._parts.query=a.buildQuery(s,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),"string"!=typeof t&&(r=e),this.build(!r),this},i.removeQuery=function(t,e,r){var s=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return a.removeQuery(s,t,e),this._parts.query=a.buildQuery(s,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),"string"!=typeof t&&(r=e),this.build(!r),this},i.hasQuery=function(t,e,r){var s=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return a.hasQuery(s,t,e,r)},i.setSearch=i.setQuery,i.addSearch=i.addQuery,i.removeSearch=i.removeQuery,i.hasSearch=i.hasQuery,i.normalize=function(){return this._parts.urn?this.normalizeProtocol(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build():this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()},i.normalizeProtocol=function(t){return"string"==typeof this._parts.protocol&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!t)),this},i.normalizeHostname=function(r){return this._parts.hostname&&(this.is("IDN")&&t?this._parts.hostname=t.toASCII(this._parts.hostname):this.is("IPv6")&&e&&(this._parts.hostname=e.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!r)),this},i.normalizePort=function(t){return"string"==typeof this._parts.protocol&&this._parts.port===a.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!t)),this},i.normalizePath=function(t){var e,r=this._parts.path;if(!r)return this;if(this._parts.urn)return this._parts.path=a.recodeUrnPath(this._parts.path),this.build(!t),this;if("/"===this._parts.path)return this;var s,n,i="";for("/"!==(r=a.recodePath(r)).charAt(0)&&(e=!0,r="/"+r),"/.."!==r.slice(-3)&&"/."!==r.slice(-2)||(r+="/"),r=r.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/"),e&&(i=r.substring(1).match(/^(\.\.\/)+/)||"")&&(i=i[0]);-1!==(s=r.search(/\/\.\.(\/|$)/));)0!==s?(-1===(n=r.substring(0,s).lastIndexOf("/"))&&(n=s),r=r.substring(0,n)+r.substring(s+3)):r=r.substring(3);return e&&this.is("relative")&&(r=i+r.substring(1)),this._parts.path=r,this.build(!t),this},i.normalizePathname=i.normalizePath,i.normalizeQuery=function(t){return"string"==typeof this._parts.query&&(this._parts.query.length?this.query(a.parseQuery(this._parts.query,this._parts.escapeQuerySpace)):this._parts.query=null,this.build(!t)),this},i.normalizeFragment=function(t){return this._parts.fragment||(this._parts.fragment=null,this.build(!t)),this},i.normalizeSearch=i.normalizeQuery,i.normalizeHash=i.normalizeFragment,i.iso8859=function(){var t=a.encode,e=a.decode;a.encode=escape,a.decode=decodeURIComponent;try{this.normalize()}finally{a.encode=t,a.decode=e}return this},i.unicode=function(){var t=a.encode,e=a.decode;a.encode=g,a.decode=unescape;try{this.normalize()}finally{a.encode=t,a.decode=e}return this},i.readable=function(){var e=this.clone();e.username("").password("").normalize();var r="";if(e._parts.protocol&&(r+=e._parts.protocol+"://"),e._parts.hostname&&(e.is("punycode")&&t?(r+=t.toUnicode(e._parts.hostname),e._parts.port&&(r+=":"+e._parts.port)):r+=e.host()),e._parts.hostname&&e._parts.path&&"/"!==e._parts.path.charAt(0)&&(r+="/"),r+=e.path(!0),e._parts.query){for(var s="",n=0,i=e._parts.query.split("&"),o=i.length;n<o;n++){var h=(i[n]||"").split("=");s+="&"+a.decodeQuery(h[0],this._parts.escapeQuerySpace).replace(/&/g,"%26"),void 0!==h[1]&&(s+="="+a.decodeQuery(h[1],this._parts.escapeQuerySpace).replace(/&/g,"%26"))}r+="?"+s.substring(1)}return r+=a.decodeQuery(e.hash(),!0)},i.absoluteTo=function(t){var e,r,s,n=this.clone(),i=["protocol","username","password","hostname","port"];if(this._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(t instanceof a||(t=new a(t)),n._parts.protocol||(n._parts.protocol=t._parts.protocol),this._parts.hostname)return n;for(r=0;s=i[r];r++)n._parts[s]=t._parts[s];return n._parts.path?".."===n._parts.path.substring(-2)&&(n._parts.path+="/"):(n._parts.path=t._parts.path,n._parts.query||(n._parts.query=t._parts.query)),"/"!==n.path().charAt(0)&&(e=(e=t.directory())||(0===t.path().indexOf("/")?"/":""),n._parts.path=(e?e+"/":"")+n._parts.path,n.normalizePath()),n.build(),n},i.relativeTo=function(t){var e,r,s,n,i,o=this.clone().normalize();if(o._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(t=new a(t).normalize(),e=o._parts,r=t._parts,n=o.path(),i=t.path(),"/"!==n.charAt(0))throw new Error("URI is already relative");if("/"!==i.charAt(0))throw new Error("Cannot calculate a URI relative to another relative URI");if(e.protocol===r.protocol&&(e.protocol=null),e.username!==r.username||e.password!==r.password)return o.build();if(null!==e.protocol||null!==e.username||null!==e.password)return o.build();if(e.hostname!==r.hostname||e.port!==r.port)return o.build();if(e.hostname=null,e.port=null,n===i)return e.path="",o.build();if(!(s=a.commonPath(n,i)))return o.build();var h=r.path.substring(s.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");return e.path=h+e.path.substring(s.length)||"./",o.build()},i.equals=function(t){var e,r,s,n,i,h=this.clone(),u=new a(t),c={};if(h.normalize(),u.normalize(),h.toString()===u.toString())return!0;if(s=h.query(),n=u.query(),h.query(""),u.query(""),h.toString()!==u.toString())return!1;if(s.length!==n.length)return!1;for(i in e=a.parseQuery(s,this._parts.escapeQuerySpace),r=a.parseQuery(n,this._parts.escapeQuerySpace),e)if(o.call(e,i)){if(p(e[i])){if(!d(e[i],r[i]))return!1}else if(e[i]!==r[i])return!1;c[i]=!0}for(i in r)if(o.call(r,i)&&!c[i])return!1;return!0},i.duplicateQueryParameters=function(t){return this._parts.duplicateQueryParameters=!!t,this},i.escapeQuerySpace=function(t){return this._parts.escapeQuerySpace=!!t,this},a}(t.punycode,t.IPv6,t.SecondLevelDomains,t)}(this);